//=====================================================================================================
//                                      M400, M100 2-wire                                                   
//=====================================================================================================
//                                                                                                     
//! file                                                                                      
//!                                                                                                    
//! brief      str file                                                                                       
//!                                                                                                    
//!                                                                                                    
//! (c) Copyright 2004-2013 Mettler-Toledo All Rights Reserved                                         
//! author  Daniel Zhang                                                                              
//                                                                                                     
// $Date: 2017/06/20 01:30:18 $:
// $State: Exp $:
// $Revision: 1.42.2.2 $: 
//
//=============================================================================

#define CYCLE_TIME_PV_CHART 				3000 	// 3 s update time
#define CYCLE_TIME_SV_CHART 				3000 	// 3 s update time
#define CYCLE_TIME_CURRENT_CHART			3000 	// 3 s update time
#define CYCLE_TIME_LENGTH_CHART             180000  // 3 minutes = 3 * 60 * 1000ms


#define _CAL_VARIABLE_DEFINE()                \
    	int result,i,calmode,retry,delay_time;         \
	    long select;                        \
		char status[STATUS_SIZE];           \
		unsigned char processing;           \
        float calslope1, caloffset1;        \
        int CalPressUnits;                  \
        float CalPressValue;

#define _CAL_WRITE_COND_COMPENSATION()                                \
        if((calibCondCompMode == 1)||(calibCondCompMode == 2))      \
        {                                                           \
            do                                                      \
            {                                                       \
                retry = 0;                                          \
                GET_DEV_VAR_VALUE("Compensation Value:", calibCondCompValue);\
                send(221, status);                                  \
                if (( status[STATUS_RESPONSE_CODE] == 3) || (status[STATUS_RESPONSE_CODE] == 4))\
                {                                                                               \
                    display_response_status(221, status[STATUS_RESPONSE_CODE]);                 \
                    retry = 1;                                       \
                }                                                    \
                else if (status[STATUS_RESPONSE_CODE])               \
                {                                                    \
        			cal_error(221, status[STATUS_RESPONSE_CODE]);    \
        		}                                                    \
            } while (retry);                                         \
        }


//Calc proposed Calibration Values	
#define _CAL_CALIBRATE()                                              \
		_CAL_SEND_CMD_AND_CHECK_STATUS(150)                         \
		if(calculationStatus)                                       \
		{                                                           \
			ACKNOWLEDGE("ERROR:Calibration Failure");               \
			process_abort();			                            \
		}                                                           \
        else                                                        \
        {                                                           \
            if((calibrationMode >=1)&&(calibrationMode <=3))        \
            {                                                       \
                calslope1 = calslope * 59.16/100;                   \
                caloffset1 = caloffset/calslope1 + phIsothermal;    \
                ACKNOWLEDGE("Slope(Percent): %{calslope}\n"         \
                            "Slope(mV/pH): %{calslope1}\n"          \
                            "Offset(mV): %{caloffset}\n"            \
                            "Offset(pH): %{caloffset1}\n");         \
            }                                                       \
            else if((calibrationMode == 4)||(calibrationMode == 15))\
            {                                                       \
                ACKNOWLEDGE("ORP Offset(mV): %{caloffset}\n");      \
            }                                                       \
            else if((calibrationMode >=5)&&(calibrationMode <=8))   \
            {                                                       \
                ACKNOWLEDGE("Slope(nA): %{calslope}\n"              \
                            "Offset(nA): %{caloffset}\n");          \
            }                                                       \
            else if((calibrationMode >=9)&&(calibrationMode <=14))  \
            {                                                       \
                ACKNOWLEDGE("M: %{calslope}\n"                      \
                            "A: %{caloffset}\n");                   \
            }                                                       \
            else                                                    \
            {                                                       \
                ACKNOWLEDGE("Slope: %{calslope}\n"                  \
                            "Offset: %{caloffset}\n");              \
            }                                                       \
            processCurrentCalibCal = SELECT_FROM_LIST("Complete calibration procedure.Select either Adjust,Calibrate or Abort:\n","Adjust;Calibrate;Abort");\
            if(processCurrentCalibCal < 2)                          \
            {                                                       \
        		_CAL_SEND_CMD_AND_CHECK_STATUS(143)                 \
		                                                            \
                DELAY(15, "Wait until new calc values have been stored");\
                                                                        \
                _CAL_SEND_CMD_AND_CHECK_STATUS(218)                 \
                                                                    \
                if(savingStatus == 1)                   \
                {                                                   \
                    ACKNOWLEDGE("ERROR:Stored Failed");             \
                    process_abort();                                \
                }                                                   \
                else if(savingStatus == 0)              \
                {                                                   \
                    processing = 0;                                 \
                }                                                   \
                else                                                \
                {                                                   \
            		processing = 1;		                            \
            		while(processing)                               \
                    {                                               \
                        DELAY(3, "Wait until new calc values have been stored");\
                        _CAL_SEND_CMD_AND_CHECK_STATUS(218)         \
                        if(savingStatus == 1)           \
                        {                                           \
                            ACKNOWLEDGE("ERROR:Stored Failed");     \
                            process_abort();                        \
                        }                                           \
                        else if(savingStatus == 0)      \
                        {                                           \
                            processing = 0;                         \
                        }                                           \
                    }                                               \
                }                                                   \
                if(((calibrationMode >=1)&&(calibrationMode <=4)) || (calibrationMode ==15))    \
                {                                                   \
                    if(SENSOR_CHANNEL_DIGITAL)                      \
                        send(147, status);                          \
                    send(148, status);                              \
                }                                                   \
                else if((calibrationMode >=5)&&(calibrationMode <=8))\
                {                                                   \
                    if(SENSOR_CHANNEL_DIGITAL)                      \
                        send(164, status);                          \
                    send(222, status);                              \
                }                                                   \
                else if((calibrationMode >=9)&&(calibrationMode <=14))\
                {                                                   \
                    if(SENSOR_CHANNEL_DIGITAL)                      \
                        send(165, status);                          \
                    send(142, status);                             \
                }                                                   \
            }                                                       \
            calmode = calibrationMode;                              \
            calibrationMode = 0;                                    \
            _CAL_SEND_CMD_AND_CHECK_STATUS(144)                     \
            if((calmode == 7) || (calmode == 8))                    \
            {                                                       \
                send(163, status);                                  \
            }                                                       \
            if ( (calmode !=  3) && (calmode !=  5) && (calmode !=  6) && (calmode != 11) && (calmode != 14) && (calmode != 15) )\
            {                                                       \
                if(processCurrentCalibCal < 2)                      \
                {                                                   \
                    ACKNOWLEDGE("Calibration Done.\n"               \
                                "Re-Insert Sensor");                \
                }                                                   \
                else                                                \
                {                                                   \
                    ACKNOWLEDGE("Calibration Not Done.\n"           \
                                "Re-Insert Sensor");                \
                }                                                   \
            }                                                       \
            else                                                    \
            {                                                       \
                send_command(48);                                   \
                if(processCurrentCalibCal < 2)                      \
                {                                                   \
                    ACKNOWLEDGE("Calibration Done");                \
                }                                                   \
                else                                                \
                {                                                   \
                    ACKNOWLEDGE("Calibration Not Done");            \
                }                                                   \
            }                                                       \
        }   

#define _CAL_SEND_CMD_AND_CHECK_STATUS(CMD_NUM) \
        send(CMD_NUM, status);                  \
        if (status[STATUS_RESPONSE_CODE])       \
		{                                       \
			display_response_status(CMD_NUM, status[STATUS_RESPONSE_CODE]);\
            process_abort();                    \
		}

#define _CAL_CHECK_ERROR(CMD_NUM)               \
        if (status[STATUS_RESPONSE_CODE])       \
		{                                       \
			display_response_status(CMD_NUM, status[STATUS_RESPONSE_CODE]);\
            process_abort();                    \
		}                                   

#define _CAL_ENTER(CMD_NUM)                     \
        IGNORE_ALL_DEVICE_STATUS();             \
        XMTR_IGNORE_ALL_DEVICE_STATUS();        \
                                                \
		calibrationMode = CMD_NUM;              \
        _CAL_SEND_CMD_AND_CHECK_STATUS(144)     \
        add_abort_method(cal_abort);            


#ifdef _DTM_only
#define _CAL_PRO_CAL_STEP1                                          \
        _CAL_SEND_CMD_AND_CHECK_STATUS(149)                         \
        MenuDisplay(CAL_Process_Cal_Display,str_abort_next,select);       \
        if(select == 0)                                             \
        {                                                           \
             process_abort();                                       \
        }                                                           \
        calibPointSelection =0;                                     \
        _CAL_SEND_CMD_AND_CHECK_STATUS(236)                         \
        _CAL_SEND_CMD_AND_CHECK_STATUS(145)                         \
        send_command(48);                                           \
        ACKNOWLEDGE("Captured value is stored.\n"                   \
                    "Take a grab sample to be measured in the lab or perform a parallel measurement.");     

#define _CAL_PRO_CAL_STEP2                                          \
    _CAL_SEND_CMD_AND_CHECK_STATUS(149)                             \
    calibValue_loc = sensorValue;                                   \
    sensorValue_loc = sensorValue;                                  \
    MenuDisplay(CAL_Input_Lab_Val,str_abort_next,select);           \
    calibValue = calibValue_loc;                                    \
    if(select == 0)                                                 \
    {                                                               \
        process_abort();                                            \
    }                                                               \
    _CAL_SEND_CMD_AND_CHECK_STATUS(146)                             \
    _CAL_SEND_CMD_AND_CHECK_STATUS(235)                             \
    _CAL_CALIBRATE()


#else
#define _CAL_PRO_CAL_STEP1                                          \
        _CAL_SEND_CMD_AND_CHECK_STATUS(149)                         \
        MenuDisplay(CAL_Process_Cal_Display,str_abort_next,select);       \
        calibPointSelection =0;                                     \
        _CAL_SEND_CMD_AND_CHECK_STATUS(236)                         \
        _CAL_SEND_CMD_AND_CHECK_STATUS(145)                         \
        send_command(48);                                           \
        ACKNOWLEDGE("Captured value is stored.\n"                   \
                    "Take a grab sample to be measured in the lab or perform a parallel measurement.");     

#define _CAL_PRO_CAL_STEP2                                          \
    _CAL_SEND_CMD_AND_CHECK_STATUS(149)                             \
    calibValue = sensorValue;                                       \
    GET_DEV_VAR_VALUE("|en zz|Captured value: %[.3f]{sensorValue} %{sensorValueUnit}\n Enter ref.value:"                              \
                      "|en|Actual captured value in step 1: %[.3f]{sensorValue} %{sensorValueUnit}\nEnter reference value(lab value or parallel measurement):",  calibValue);\
    _CAL_SEND_CMD_AND_CHECK_STATUS(146)                             \
    _CAL_SEND_CMD_AND_CHECK_STATUS(235)                             \
    _CAL_CALIBRATE()



#endif

                                                


#define MT_HART_UNITS \
    { 170,      [mg_l],             [mg_l_help] },                  \
    { 173,      [mega_ohmCm],       [mega_ohm_centimeter_help] },   \
    { 240,      "   ",             "const value" },                 \
    { 241,      [mega_ohm],         [mega_ohm_help] },              \
    { 242,      [ppth],             [ppth_help] },                  \
    { 243,      "nA",               "nano ampere helps" },          \
    ALL_UNITS  

#ifdef __C300KK   
#define  MT_UNITS_LIST \
        IF(SENSOR_COND)\
        {\
            {21, "ms/cm"},\
            {22, "us/cm"},\
            {23, "MOhm*cm"},\
            {24, "TDS NaCl(ppm)"},\
            {25, "TDS NaCl(ppb)"},\
            {26, "TDS NaCl(ppk)"},\
            {27, "TDS CaCO3(ppm)"},\
            {28, "TDS CaCO3(ppb)"},\
            {29, "TDS CaCO3(ppk)"},\
            {30, "%NaOH"},\
            {31, "%NaCl"},\
            {32, "%H2SO4"},\
            {33, "%H3PO4"},\
            {34, "%HNO3"},\
            {35, "%HCl"},\
            {37, "%Conc"}\
        }\
        ELSE\
        {\
            IF(SENSOR_PH)\
            {\
                {6, "pH"},\
                {7, "mV pH"},\
                {8, "ORP"},\
                {9, "Rg"},\
                {10, "RpNa"},\
                {11, "Rr"}\
            }\
            IF(SENSOR_O2)\
            {\
                {17, "%air"},\
                {12, "mg/l"},\
                {13, "ug/l"},\
                {14, "ppm"},\
                {15, "ppb"},\
                {16, "%O2"},\
				{18, "%O2G"},\
				{19, "ppmO2G"},\
                {20, "nA"},\
                {36, "mbar P"}\
            }\
            {3, "DLI"},\
            {4, "TTM"},\
            {5, "ACT"}\
        }\
        {0, "DegC"},\
        {1, "DegF"},\
        {2, "None(const)"}
      
#elif defined __C100_DINRAIL

        #define  MT_UNITS_LIST \
        IF(SENSOR_COND)\
        {\
            {21, "ms/cm"},\
            {22, "us/cm"},\
            {23, "MOhm*cm"},\
            {24, "TDS NaCl(ppm)"},\
            {25, "TDS NaCl(ppb)"},\
            {26, "TDS NaCl(ppk)"},\
            {27, "TDS CaCO3(ppm)"},\
            {28, "TDS CaCO3(ppb)"},\
            {29, "TDS CaCO3(ppk)"},\
            {30, "%NaOH"},\
            {31, "%NaCl"},\
            {32, "%H2SO4"},\
            {33, "%H3PO4"},\
            {34, "%HNO3"},\
            {35, "%HCl"}\
        }\
        ELSE\
        {\
            IF(SENSOR_PH)\
            {\
                {6, "pH"},\
                {7, "mV pH"},\
                {8, "ORP"},\
                {9, "Rg"},\
                {10, "RpNa"},\
                {11, "Rr"}\
            }\
            IF(SENSOR_O2)\
            {\
                {17, "%air"},\
                {12, "mg/l"},\
                {13, "ug/l"},\
                {14, "ppm"},\
                {15, "ppb"},\
                {16, "%O2"},\
                {20, "nA"},\
                {36, "mbar P"}\
            }\
            {3, "DLI"},\
            {4, "TTM"},\
            {5, "ACT"}\
        }\
        {0, "DegC"},\
        {1, "DegF"},\
        {2, "None(const)"}
#else

        #define  MT_UNITS_LIST \
        IF(SENSOR_COND)\
        {\
            {21, "ms/cm"},\
            {22, "us/cm"},\
            {23, "MOhm*cm"},\
            {24, "TDS NaCl(ppm)"},\
            {25, "TDS NaCl(ppb)"},\
            {26, "TDS NaCl(ppk)"},\
            {27, "TDS CaCO3(ppm)"},\
            {28, "TDS CaCO3(ppb)"},\
            {29, "TDS CaCO3(ppk)"},\
            {30, "%NaOH"},\
            {31, "%NaCl"},\
            {32, "%H2SO4"},\
            {33, "%H3PO4"},\
            {34, "%HNO3"},\
            {35, "%HCl"}\
        }\
        ELSE\
        {\
            IF(SENSOR_PH)\
            {\
                {6, "pH"},\
                {7, "mV pH"},\
                {8, "ORP"},\
                {9, "Rg"},\
                {10, "RpNa"},\
                {11, "Rr"}\
            }\
            IF(SENSOR_O2)\
            {\
                {17, "%air"},\
                {12, "mg/l"},\
                {13, "ug/l"},\
                {14, "ppm"},\
                {15, "ppb"},\
                {16, "%O2"},\
                {18, "%O2G"},\
                {19, "ppmO2G"},\
                {20, "nA"},\
                {36, "mbar P"}\
            }\
            {3, "DLI"},\
            {4, "TTM"},\
            {5, "ACT"}\
        }\
        {0, "DegC"},\
        {1, "DegF"},\
        {2, "None(const)"}
#endif

